/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;

public class EntityStormSwords
extends EntityAbstractSummonedSword {
    private static final EntityDataAccessor<Boolean> IT_FIRED = SynchedEntityData.m_135353_(EntityStormSwords.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityStormSwords(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setPierce((byte)1);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IT_FIRED, (Object)false);
    }

    public void doFire() {
        this.m_20088_().m_135381_(IT_FIRED, (Object)true);
    }

    public boolean itFired() {
        return (Boolean)this.m_20088_().m_135370_(IT_FIRED);
    }

    public static EntityStormSwords createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityStormSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.StormSwords, worldIn);
    }

    public void m_6083_() {
        if (this.itFired()) {
            this.faceEntityStandby();
            Entity target = this.m_20202_();
            this.m_8127_();
            this.f_19797_ = 0;
            Vec3 dir = this.m_20252_(1.0f);
            if (target != null) {
                dir = target.m_20182_().m_82546_(this.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
            }
            this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 3.0f, 1.0f);
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.canUpdate()) {
            this.m_6075_();
        }
        this.faceEntityStandby();
        if (20 <= this.f_19797_) {
            this.doFire();
        }
        if (!this.m_9236_().m_5776_()) {
            this.hitCheck();
        }
    }

    private void hitCheck() {
        Vec3 positionVec = this.m_20182_();
        Vec3 dirVec = this.m_20252_(1.0f);
        EntityHitResult raytraceresult = null;
        EntityHitResult entityraytraceresult = this.getRayTrace(positionVec, dirVec);
        if (entityraytraceresult != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = raytraceresult.m_82443_();
            Entity entity1 = this.getShooter();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY && !ForgeEventFactory.onProjectileImpact((net.minecraft.world.entity.projectile.Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
            this.resetAlreadyHits();
            this.f_19812_ = true;
        }
    }

    private void faceEntityStandby() {
        long cycle = 5 + this.f_19797_;
        long tickOffset = 0L;
        if (this.m_9236_().f_46443_) {
            tickOffset = 1L;
        }
        int ticks = (int)(((long)this.f_19797_ + tickOffset) % cycle);
        double rotParTick = 360.0 / (double)cycle;
        double offset = this.getDelay();
        double degYaw = ((double)ticks * rotParTick + offset) % 360.0;
        double yaw = Math.toRadians(degYaw);
        Vec3 dir = new Vec3(0.0, 0.0, 1.0);
        dir = dir.m_82524_((float)(-yaw));
        dir = dir.m_82541_().m_82490_(4.0);
        if (this.m_20202_() != null) {
            dir = dir.m_82549_(this.m_20202_().m_20182_());
            dir = dir.m_82520_(0.0, (double)this.m_20202_().m_20192_() / 2.0, 0.0);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_146884_(dir);
        double pitchFactor = 7.5;
        this.m_19915_((float)(-degYaw) - 180.0f, 0.0f);
    }

    @Override
    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity targetEntity = p_213868_1_.m_82443_();
        if (targetEntity instanceof LivingEntity) {
            KnockBacks.toss.action.accept((LivingEntity)targetEntity);
            StunManager.setStun((LivingEntity)targetEntity);
        }
        super.m_5790_(p_213868_1_);
    }

    @Override
    protected void m_8060_(BlockHitResult blockraytraceresult) {
        this.burst();
    }
}

